<?php

/**
 * Steps Request
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\SerializationContext;

/**
 * Steps Request
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @Serializer\XmlRoot("SsoRequest")
 */
class Request
{

    /**
     *
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\Request\Credentials\Credentials")
     * @Serializer\Expose
     * @var Request\Credentials\Credentials
     */
    private $credentials;

    /**
     *
     * @Serializer\Groups({"Request::UserIdentifier::Get", "Request::UserIdentifier::Validate"})
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\Request\Controller\UserIdentifierController")
     * @var Request\Controller\UserIdentifierController
     */
    private $userController;

    /**
     * 
     * @param Request\Credentials\Credentials $credentials
     * @return Request
     */
    public function setCredentials(Request\Credentials\Credentials $credentials)
    {
        $this->credentials = $credentials;

        return $this;
    }

    /**
     * 
     * @param Request\Controller\UserIdentifierController $userController
     * @return Request
     */
    public function setUserIdentifierController(Request\Controller\UserIdentifierController $userController)
    {
        $this->userController = $userController;

        return $this;
    }

    /**
     * 
     * @return Request\Controller\ControllerInterface
     */
    public function getController()
    {
        return $this->userController;
    }

    /**
     * @return SerializationContext Description
     */
    public function getSerializationContext()
    {
        $groups = array(
            'Request::Credentials',
            'Request::' . $this->getController()->getName() . '::' . $this->getController()->getCurrentAction()->getName()
        );
        return SerializationContext::create()->setGroups($groups);
    }

}