<?php

/**
 * Steps Credentials
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Request\Credentials;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps Credentials
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Credentials
{

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("ServiceProvider");
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\Request\Credentials\ServiceProvider")
     * @var ServiceProvider
     */
    private $serviceProvider;

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("ServiceTrigger");
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\Request\Credentials\ServiceTrigger")
     * @var ServiceTrigger
     */
    private $serviceTrigger;

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("ServiceCountry");
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\Request\Credentials\ServiceCountry")
     * @var ServiceCountry
     */
    private $serviceCountry;

    /**
     * 
     * @param ServiceProvider $serviceProvider
     * @return Credentials
     */
    public function setServiceProvider(ServiceProvider $serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;

        return $this;
    }

    /**
     * 
     * @param ServiceTrigger $serviceTrigger
     * @return Credentials
     */
    public function setServiceTrigger(ServiceTrigger $serviceTrigger)
    {
        $this->serviceTrigger = $serviceTrigger;

        return $this;
    }

    /**
     * 
     * @param ServiceCountry $serviceCountry
     * @return Credentials
     */
    public function setServiceCountry(ServiceCountry $serviceCountry)
    {
        $this->serviceCountry = $serviceCountry;

        return $this;
    }

}