<?php

/**
 * Steps UserIdentifierController
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Response\Controller;

use JMS\Serializer\Annotation as Serializer;
use Sso\Component\IdentifyServiceBundle\Exception\InvalidNodeElementException;

/**
 * Steps UserIdentifierController
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class UserIdentifierController implements ControllerInterface
{

    /**
     *
     * @Serializer\Groups({"Response::UserIdentifier::Get"})
     * @Serializer\SerializedName("Get")
     * @Serializer\Type("array<Sso\Component\IdentifyServiceBundle\Node\Response\Controller\UserIdentifierController\GetAction>")
     * @Serializer\XmlList(inline = true, entry = "Get")
     * @var UserIdentifierController\GetAction[]
     */
    private $getActions;

    /**
     *
     * @Serializer\Groups({"Response::UserIdentifier::Validate"})
     * @Serializer\SerializedName("Validate")
     * @Serializer\Type("array<Sso\Component\IdentifyServiceBundle\Node\Response\Controller\UserIdentifierController\ValidateAction>")
     * @Serializer\XmlList(inline = true, entry = "Validate")
     * @var UserIdentifierController\ValidateAction[]
     */
    private $validateActions;

    /**
     *
     * @Serializer\Exclude
     * @var ActionInterface
     */
    private $currentAction;

    /**
     * 
     * @param UserIdentifierController\GetAction $getAction
     * @return UserIdentifierController
     */
    public function addGetAction(UserIdentifierController\GetAction $getAction)
    {
        if (null !== $this->validateActions) {
            throw new InvalidNodeElementException('Validate- and get-action may not be set in same request!');
        }
        if (null === $this->currentAction) {
            $this->currentAction = $getAction;
        }
        $this->getActions[] = $getAction;

        return $this;
    }

    /**
     * 
     * @param UserIdentifierController\ValidateAction $validateAction
     * @return UserIdentifierController
     */
    public function addValidateAction(UserIdentifierController\ValidateAction $validateAction)
    {
        if (null !== $this->getActions) {
            throw new InvalidNodeElementException('Validate- and get-action may not be set in same request!');
        }
        if (null === $this->currentAction) {
            $this->currentAction = $validateAction;
        }
        $this->validateActions[] = $validateAction;

        return $this;
    }

    /**
     * 
     * @return ActionInterface[]
     */
    public function getActions()
    {
        if (null !== $this->getActions) {
            return $this->getActions;
        }
        if (null !== $this->validateActions) {
            return $this->validateActions;
        }
        return array();
    }

    /**
     * 
     * @return ActionInterface
     */
    public function getCurrentAction()
    {
        return $this->currentAction;
    }

    /**
     * Get controller name
     * 
     * @return string
     */
    public function getName()
    {
        return 'UserIdentifier';
    }

}