<?php

/**
 * Steps BaseAction
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Response\Controller\UserIdentifierController;

use JMS\Serializer\Annotation as Serializer;
use Sso\Component\IdentifyServiceBundle\Node\Response\Controller\ActionInterface;
use Sso\Component\IdentifyServiceBundle\Node\Response\Error;

/**
 * Steps BaseAction
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
abstract class BaseAction implements ActionInterface
{

    /**
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     * @var string
     */
    private $status;

    /**
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("array<Sso\Component\IdentifyServiceBundle\Node\Response\Error>")
     * @Serializer\XmlList(entry="Error")
     * @Serializer\XmlElement(cdata=false)
     * @var Error[]
     */
    private $errors;

    /**
     * Set Status
     * 
     * @param string|boolean $status
     * @return BaseAction
     */
    public function setStatus($status)
    {
        $this->status = (true === $status || $status == 'Success') ? 'Success' : 'Failure';

        return $this;
    }

    /**
     * 
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * 
     * @param Error $error
     * @return BaseAction
     */
    public function addError(Error $error)
    {
        $this->errors[] = $error;

        return $this;
    }

    /**
     * 
     * @return Error[]
     */
    public function getErrors()
    {
        return null !== $this->errors ? $this->errors : array();
    }

}