# Life-Style - SSO Identity Provider

This is version 2 of Life-Styles Identity Provider – completely redesigned using the latest version of [simpleSAMLphp](https://simplesamlphp.org) and [Symfony 4](https://symfony.com)!

## Requirements

- PHP 7.1.3
- mysql 5.7
- Apache 2.4

## Installation

```shell script
cp .env .env.local
```

Adjust `.env.local` file to your needs.

```shell script
composer install
npm install
npm run build
```

## Create database

```shell script
php bin/console doctrine:database:create --if-not-exists
php bin/console doctrine:migrations:migrate
```

## Configure simpleSAMLphp

See [simpleSAMLphp](https://simplesamlphp.org/docs/stable/simplesamlphp-idp) documentation for detailed information. Store your SAML configuration into folder `config\saml\[prod|dev]`.

## Configure Apache

```
<VirtualHost *:80>
    ServerName your-identity-provider-domain.tld

    DocumentRoot "/absolute/path/to/your/project/vendor/simplesamlphp/simplesamlphp/www"

    <Directory "/absolute/path/to/your/project/vendor/simplesamlphp/simplesamlphp/www">
        Options Includes FollowSymLinks ExecCGI
        AllowOverride None

        <IfModule authz_host_module>
            Order allow,deny
            Allow from all
        </IfModule>

        # for AWS only
        <IfModule mod_rewrite.c>
            RewriteEngine On
            RewriteCond %{HTTP_USER_AGENT} ^ELB-HealthChecker
            RewriteRule .* /service [L]
        </IfModule>
    </Directory>

    Alias /service /absolute/path/to/your/project/public
    <Directory /absolute/path/to/your/project/public>
        Options Includes FollowSymLinks
        AllowOverride None
        Order allow,deny
        Allow from all
        DirectoryIndex index.php
        <IfModule mod_negotiation.c>
            Options -MultiViews
        </IfModule>
        <IfModule mod_rewrite.c>
            RewriteEngine On
            RewriteCond %{REQUEST_URI}::$1 ^(/.+)/(.*)::\2$
            RewriteRule ^(.*) - [E=BASE:%1]
            RewriteCond %{HTTP:Authorization} .
            RewriteRule ^ - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]
            RewriteCond %{ENV:REDIRECT_STATUS} ^$
            RewriteRule ^index\.php(?:/(.*)|$) %{ENV:BASE}/$1 [R=301,L]
            RewriteCond %{REQUEST_FILENAME} -f
            RewriteRule ^ - [L]
            RewriteRule ^ %{ENV:BASE}/index.php [L]
        </IfModule>
        <IfModule !mod_rewrite.c>
            <IfModule mod_alias.c>
                RedirectMatch 307 ^/$ /index.php/
            </IfModule>
        </IfModule>
    </Directory>

    SetEnv SIMPLESAMLPHP_CONFIG_DIR /absolute/path/to/your/project/config/saml/prod
</VirtualHost>
```
