/*
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

var security = require("./security");
var captcha = function () {

    /**
     * Init some javascript stuff against attacks
     */
    function initCaptcha()
    {
        fillAddFields();
    }

    /**
     * Fill additional fields from username
     *
     * @return {void}
     */
    function fillAddFields()
    {
        var usernameField = $("#username");
        var firstNameField = $("#firstname");
        var lastNameField = $("#lastname");

        if (0 === usernameField.length || 0 === firstNameField.length || 0 === lastNameField.length) {
            return;
        }

        var usernameInit = usernameField.val();
        if (usernameInit.length > 0) {
            firstNameField.val(security.encryptFirstName(usernameInit));
            lastNameField.val(security.encryptLastName(usernameInit));
        }

        // Bind the user field
        usernameField.on('input propertychange', function () {
            var username = usernameField.val();
            firstNameField.val(security.encryptFirstName(username));
            lastNameField.val(security.encryptLastName(username));
        });
    }

    return {
        init: initCaptcha
    };
}();

module.exports = captcha;
