/**
 * LIFESTYLE SSO-IDP-SP / Forminputs
 * Author: LifeStyle Webconsulting GmbH, Sebastian Gronauer, www.life-style.de
 */

if (!Object.keys) {
    Object.keys = (function () {
        'use strict';
        var hasOwnProperty = Object.prototype.hasOwnProperty,
            hasDontEnumBug = !({toString: null}).propertyIsEnumerable('toString'),
            dontEnums = [
                'toString',
                'toLocaleString',
                'valueOf',
                'hasOwnProperty',
                'isPrototypeOf',
                'propertyIsEnumerable',
                'constructor'
            ],
            dontEnumsLength = dontEnums.length;

        return function (obj) {
            if (typeof obj !== 'object' && (typeof obj !== 'function' || obj === null)) {
                throw new TypeError('Object.keys called on non-object');
            }

            var result = [], prop, i;

            for (prop in obj) {
                if (hasOwnProperty.call(obj, prop)) {
                    result.push(prop);
                }
            }

            if (hasDontEnumBug) {
                for (i = 0; i < dontEnumsLength; i++) {
                    if (hasOwnProperty.call(obj, dontEnums[i])) {
                        result.push(dontEnums[i]);
                    }
                }
            }
            return result;
        };
    }());
}

forminputs = function() {

    var form;
    var inputFields;

    function isFieldEmpty(inputField)
    {
        var inputEmpty = 0 === inputField.val().length,
            googleChromeAutofill = inputField.css("backgroundColor") === "rgb(250, 255, 189)";
        return inputEmpty && !googleChromeAutofill;
    }

    function updateDecorators(form, fields)
    {
        inputFields.each(function() {

            var inputField = $(this),
                elementId = inputField.attr('id'),
                formGroup = inputField.parent(".form-group"),
                inputLabel = formGroup.find("label"),
                inputEmpty = isFieldEmpty(inputField),
                hasFocus = inputField.is(':focus');

            if ((!inputEmpty || hasFocus) && !formGroup.hasClass("form-group-focus")) {
                formGroup.addClass("form-group-focus");
                inputLabel.addClass("labelFocus");
            }

            if (inputField.val() && $.inArray(elementId, fields) !== -1) {
                form.data('bootstrapValidator').validateField(elementId);
            }

        })
    }

    function addDecorators()
    {
        var inputField = $(this),
            formGroup = inputField.parent(".form-group"),
            inputLabel = formGroup.find("label");

        if (!formGroup.hasClass("form-group-focus")) {
            formGroup.addClass("form-group-focus");
            inputLabel.addClass("labelFocus");
        }
    }

    function removeDecorators()
    {
        var inputField = $(this),
            formGroup = inputField.parent(".form-group"),
            inputLabel = formGroup.find("label"),
            inputEmpty = 0 === inputField.val().length;

        if (inputEmpty && formGroup.hasClass("form-group-focus")) {
            formGroup.removeClass("form-group-focus");
            inputLabel.removeClass("labelFocus");
        }

        if(inputField.css("backgroundColor") === "rgb(250, 255, 189)") {
            inputField.css("backgroundColor", "transparent");
        }
    }

    function initForm() {

        if (window.loginForm === undefined) {
            window.setTimeout(initForm.bind(this), 250);
            return;
        }

        /* Receive login form from global scope */
        form = window.loginForm;
        inputFields = form.find('input[type="text"]').add(form.find('input[type="password"]'));

        var bootstrapValidator = form.data("bootstrapValidator");
        var fields = Object.keys(bootstrapValidator.options.fields);
        updateDecorators(form, fields);

        inputFields
            .on("focusin", addDecorators)
            .on("focusout", removeDecorators)
            .on("change", updateDecorators);

        /** Detect browser autofill - set input field style */
        var timer = window.setInterval(updateDecorators, 100);
        window.setTimeout(function() {
            window.clearTimeout(timer);
        }, 1500);
    }

    function init() {
        if ($("#login").length > 0) {
           initForm();
        }
    }

    return {
        init: init
    };
}();

module.exports = forminputs;
