/**
 * LIFESTYLE SSO-IDP / Navigation
 * Author: LifeStyle Webconsulting GmbH, Sebastian Gronauer, www.life-style.de
 */

var navigation = function() {

    /**
     * BIND EVENTS ON BUTTONS
     * */
    function bindEventsOnButtons () {

        /**
         * PREVENT EVENT FOR "a"-TAG INSIDE LANGUAGE SELECT
         */
        $(".languageOption.isSelected").on("click", function(e){
            e.preventDefault();
        });

        /**
         * EVENT TO OPEN AND CLOSE NAVIGATION
         */
        $(".languageButton").on("click", function() {

            /** FUNCTION TO SET THE OPACITY FOR THE NAVIGATION WHEN EXPAND */
            function setNavOpacity() {
                var nav = $('.navbar'),
                    navHeight = nav.height();
                if(navHeight >= 31 && !nav.hasClass('expand')) {
                    nav.addClass('expand');
                } else {
                    nav.removeClass('expand');
                }
            }

            /** SET TIMEOUT SO IF CONDITIONS IN FOLLOWING FUNCTION WORKS RIGHT */
            setTimeout(setNavOpacity, 75);
        });

    }

    return {
        init: bindEventsOnButtons,
        bindEventsOnButtons: bindEventsOnButtons
    };

}();

module.exports = navigation;