<?php
/**
 * SAML 2.0 remote SP metadata for simpleSAMLphp.
 *
 * See: http://simplesamlphp.org/docs/trunk/simplesamlphp-reference-sp-remote
 */

// To prevent from sending the whole bunch of ldap-attributes, use this list as default attributes
$_metaSpDefaultAttributes = array(
    'guid',
    'lastname',
    'firstname',
    'username',
    'email',
    'authsource',
    'useridentifier',
);

$metadata['identifierService'] = array(
    'AssertionConsumerService' => 'http://ls-sso-idp.local/service/',
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => array(
        'guid',
        'useridentifier',
        'username',
    ),
);

$metadata['http://ls-sso-wsp.local/simplesaml/module.php/saml/sp/metadata.php/ls-sso-idp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => $_metaSpDefaultAttributes,
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-wsp.local/simplesaml/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://ls-sso-wsp.local/simplesaml/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-wsp.local/simplesaml/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-sso-wsp.local/simplesaml/module.php/saml/sp/saml1-acs.php/ls-sso-idp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-sso-wsp.local/simplesaml/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-sso-wsp.local/simplesaml/module.php/saml/sp/saml1-acs.php/ls-sso-idp/artifact',
                ),
        ),
    'certData' => 'MIIDZzCCAk+gAwIBAgIJAKIK5DQuicThMA0GCSqGSIb3DQEBCwUAMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTAeFw0xNzEwMzAxMDA3NTBaFw0yNzEwMzAxMDA3NTBaMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOkmEGD6ED+NYM1XH+f+uP3rsPnAmMKsbXfFLZ769kAvBjBOkHiQTsiabi18ElAsLkj9nqV8MzvC+x1we/Sy0TgnExF5OlxeDp4iook0L0Jq9+SqbjfNA3ahC83iq44IzqObHG6rv2BlwhytMrVvs4ZceNZtUl8qnENdHgj40po0BTSbANU7R1aJtZ1lh7C1OnvXIT84gHNnElcOHeA3S0YpME+Mqj3YRA9ntjS447Nn/hXOm4faaSw0cKjQwurZgxO8+36k4zQGC4PwPijkTWI2u89bhNkAmOgaefskFXzhSfx6WiB4kAtF/BrkHCZ5T3nU0o+maL2zKg8DRCUnZU8CAwEAAaNQME4wHQYDVR0OBBYEFO8qDyAAfz7uD+LHI5o08dKhalTPMB8GA1UdIwQYMBaAFO8qDyAAfz7uD+LHI5o08dKhalTPMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAAPZHIPTFBOCkQjGtOi215Q5CzV423nAI6dVLZdpEVnK49eQEIIu304oJFsGTBRdkQwUMTPq5DR1P3bPmGGnbYj8IBLoX0ka01DH1aqTLO7wRGoQdffe4BnZBT/x8/YtaGFgHCb5DjTOIWDSEZ+W2svLHnSGihpo/C7lVdH76GB23zGDLiXnWSgKHdkSOodajBeOBDVtXSG8JAdcfNglnUFcY45jFJ19XN1P/8YVIKj7v9wM/uOCqi29O6/Dve4kKzdKCahlvyao6GLYb+QLzz1SORqY+Ijn94RqUIAgVXcou3cPL+LI6lgOkHQttoihfOsXTI792UTtKUu5EG7tkNs=',
);