<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Utils;

/**
 * Class Assets
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Utils
 */
class Assets
{

    /**
     * @param string $path
     * @return string
     */
    public static function getAssetsURL($path)
    {
        $baseUrl = getenv('ASSETS_BASE_URL');
        if (false !== $baseUrl) {
            return rtrim($baseUrl, '/') . '/' . ltrim($path, '/');
        }
        return $path;
    }
}
