<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Client;

use Psr\Http\Message\ResponseInterface as Message;
use SimpleSAML\Logger;
use SimpleSAML\Module\lifestyle\Webservice\Api\Configuration\Client;
use SimpleSAML\Module\lifestyle\Webservice\Cyphering\Decoder;
use SimpleSAML\Module\lifestyle\Webservice\Security\MessageDigestPasswordEncoder;

/**
 * Class Response
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Client
 */
class Response
{
    /**
     * @var Decoder
     */
    private $decoder;

    /**
     * @var MessageDigestPasswordEncoder
     */
    private $passwordEncoder;

    /**
     * @var Client
     */
    private $configuration;

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Client\Response constructor.
     * @param Decoder $decoder
     * @param MessageDigestPasswordEncoder $passwordEncoder
     * @param Client $configuration
     */
    public function __construct(
        Decoder $decoder,
        MessageDigestPasswordEncoder $passwordEncoder,
        Client $configuration
    ) {
        $this->decoder = $decoder;
        $this->passwordEncoder = $passwordEncoder;
        $this->configuration = $configuration;
    }

    /**
     * @param Message $message
     * @return string
     */
    public function receive(Message $message = null)
    {
        if (null === $message) {
            return 'empty response';
        }

        $return = $message->getBody();

        Logger::debug('webservice-response: ' . $return);

        return $return;
    }
}
