<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Cyphering;

use SimpleSAML\Module\lifestyle\Webservice\Api\Configuration\Cyphering;

/**
 * Class Manager
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Cyphering
 */
class Manager
{
    /**
     * @var Cyphering
     */
    private $configuration;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Cyphering\Manager constructor.
     * @param Cyphering $configuration
     */
    public function __construct(Cyphering $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * @return Decoder
     */
    public function decoder()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Decoder($this->configuration));
    }

    /**
     * @return Encoder
     */
    public function encoder()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Encoder($this->configuration));
    }

    /**
     * Returns true, if open-ssl-encryption is available
     * @return bool
     */
    public static function useOpenSsl(): bool
    {
        return function_exists('openssl_decrypt');
    }
}
