<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Model\Request\Mfa\PostMfaValidate;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Model\Request\Mfa\PostMfaValidate
 * @Serializer\XmlRoot("mfaValidateOtp")
 */
class Request
{
    /**
     * @Serializer\SerializedName("userIdentifier")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("otp")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $otp;

    /**
     * @param string $userIdentifier
     * @return Request
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;
        return $this;
    }

    /**
     * @param string $otp
     * @return Request
     */
    public function setOtp($otp)
    {
        $this->otp = $otp;
        return $this;
    }
}
