<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes
 */
class Request
{
    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("applications")
     * @Serializer\Type("array<SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes\ApplicationType>")
     * @Serializer\XmlList(inline = false, entry = "application")
     *
     * @var array
     */
    private $applications;

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes\Request constructor.
     * @param string $username
     */
    public function __construct($username)
    {
        $this->username = (string)$username;
    }

    /**
     * @param ApplicationType $applicationType
     * @return Request
     */
    public function addApplication(
        ApplicationType $applicationType
    ) {
        $this->applications[] = $applicationType;
        return $this;
    }
}
