<?php

use SimpleSAML\Configuration;use SimpleSAML\Module;use SimpleSAML\Module\lifestyle\Utils\UrlBuilder;use SimpleSAML\Utils\HTTP;use Symfony\Component\Asset\Package;use Symfony\Component\Asset\VersionStrategy\JsonManifestVersionStrategy;

/**
 * Support the htmlinject hook, which allows modules to change header, pre and post body on all pages.
 */
$this->data['htmlinject'] = array(
    'htmlContentPre' => array(),
    'htmlContentPost' => array(),
    'htmlContentHead' => array(),
);

$urlBuilder = new UrlBuilder(
    Configuration::getInstance(),
    $_REQUEST['AuthState'],
    $this->getLanguage()
);

$jquery = array();
if (array_key_exists('jquery', $this->data)) {
    $jquery = $this->data['jquery'];
}

if (array_key_exists('pageid', $this->data)) {
    $hookinfo = array(
        'pre' => &$this->data['htmlinject']['htmlContentPre'],
        'post' => &$this->data['htmlinject']['htmlContentPost'],
        'head' => &$this->data['htmlinject']['htmlContentHead'],
        'jquery' => &$jquery,
        'page' => $this->data['pageid']
    );

    Module::callHooks('htmlinject', $hookinfo);
}
// - o - o - o - o - o - o - o - o - o - o - o - o -


$includeLanguageBar = true;
if (!empty($_POST)) {
    $includeLanguageBar = true;
}
if (isset($this->data['hideLanguageBar']) && $this->data['hideLanguageBar'] === true) {
    $includeLanguageBar = true;
}

$currentLanguage = 'en';
$languageSelect = array();
if ($includeLanguageBar) {
    $languages = $this->getLanguageList();
    $langnames = array(
        'no' => 'Bokmål', // Norwegian Bokmål
        'nn' => 'Nynorsk', // Norwegian Nynorsk
        'se' => 'Sámegiella', // Northern Sami
        'da' => 'Dansk', // Danish
        'en' => 'English',
        'de' => 'Deutsch', // German
        'sv' => 'Svenska', // Swedish
        'fi' => 'Suomeksi', // Finnish
        'es' => 'Español', // Spanish
        'fr' => 'Français', // French
        'it' => 'Italiano', // Italian
        'nl' => 'Nederlands', // Dutch
        'lb' => 'Lëtzebuergesch', // Luxembourgish
        'cs' => 'Čeština', // Czech
        'sl' => 'Slovenščina', // Slovensk
        'lt' => 'Lietuvių kalba', // Lithuanian
        'hr' => 'Hrvatski', // Croatian
        'hu' => 'Magyar', // Hungarian
        'pl' => 'Język polski', // Polish
        'pt' => 'Português', // Portuguese
        'pt-br' => 'Português brasileiro', // Portuguese
        'ru' => 'русский язык', // Russian
        'et' => 'eesti keel', // Estonian
        'tr' => 'Türkçe', // Turkish
        'el' => 'ελληνικά', // Greek
        'ja' => '日本語', // Japanese
        'zh' => '简体中文', // Chinese (simplified)
        'zh-tw' => '繁體中文', // Chinese (traditional)
        'ar' => 'العربية', // Arabic
        'he' => 'עִבְרִית', // Hebrew
        'id' => 'Bahasa Indonesia', // Indonesian
        'sr' => 'Srpski', // Serbian
        'lv' => 'Latviešu', // Latvian
        'ro' => 'Românește', // Romanian
        'eu' => 'Euskara', // Basque
        'af' => 'Afrikaans', // Afrikaans
    );

    foreach ($languages AS $lang => $current) {
        $lang = strtolower($lang);
        if ($current) {
            $currentLanguage = $lang;
        } else {
            $languageSelect[] = '<li><a href="' . htmlspecialchars(HTTP::addURLParameters(HTTP::getSelfURL(), array($this->getTranslator()->getLanguage()->getLanguageParameterName() => $lang))) . '">' . $lang . '</a></li>';
        }
    }
}

$package = new Package(new JsonManifestVersionStrategy($_SERVER['DOCUMENT_ROOT'] . '/build/manifest.json'));

/**
 * Do not allow to frame simpleSAMLphp pages from another location.
 * This prevents clickjacking attacks in modern browsers.
 *
 * If you don't want any framing at all you can even change this to
 * 'DENY', or comment it out if you actually want to allow foreign
 * sites to put simpleSAMLphp in a frame. The latter is however
 * probably not a good security practice.
 */
header('X-Frame-Options: SAMEORIGIN');
?><!DOCTYPE html>
<!--[if lt IE 7]>
<html dir="ltr" lang="<?php echo $currentLanguage; ?>" class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>
<html dir="ltr" lang="<?php echo $currentLanguage; ?>" class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>
<html dir="ltr" lang="<?php echo $currentLanguage; ?>" class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!-->
<html dir="ltr" lang="<?php echo $currentLanguage; ?>" class="no-js">
<!--<![endif]-->

<head>
    <!-- server-id SERVER_ID -->
    <meta charset="utf-8"/>
    <meta name="viewport" content="initial-scale=1,maximum-scale=1,user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

    <meta name="description" content="<?php echo $this->t('{lifestyle:login:head_description}'); ?>"/>
    <meta name="keywords" content="<?php echo $this->t('{lifestyle:login:head_keywords}'); ?>"/>
    <meta name="robots" content="noindex, nofollow"/>

    <title>SSO - <?php
        if (array_key_exists('header', $this->data)) {
            echo $this->data['header'];
        } else {
            echo 'SSO';
        }
        ?></title>
    <link rel="stylesheet" href="<?php echo $package->getUrl('build/sso.css'); ?>"/>
    <link rel="icon" href="<?php echo $package->getUrl('build/images/favicon.ico'); ?>" type="image/ico"/>
    <?php
    if (array_key_exists('head', $this->data)) {
        echo '<!-- head -->' . $this->data['head'] . '<!-- /head -->';
    }
    ?>
</head>
<?php
$onLoad = '';
if (isset($this->data['onLoad'])) {
    $onLoad .= $this->data['onLoad'];
}

if ($onLoad !== '') {
    $onLoad = ' onload="' . $onLoad . '"';
}
?>
<body<?php echo $onLoad; ?>>
<!--[if IE 8]>
<div id="isIE8" style="width: 1px;height: 1px; line-height: 1px; position: absolute; z-index: -9999;"></div>
<![endif]-->
<!--[if IE 9]>
<div id="isIE9" style="width: 1px;height: 1px; line-height: 1px; position: absolute; z-index: -9999;"></div>
<![endif]-->

<div id="bg" class="bg">
    <div class="bgInside"></div>
</div>

<div class="navbar navbar-fixed-top" role="navigation">
    <div class="container">
        <div class="navbar-header">
            <a href="<?php echo $urlBuilder->getSsoBaseUrl(); ?>" class="logo"><img
                        src="<?php echo ($logoPath = $package->getUrl('build/images/logo.svg')) !== 'build/images/logo.svg' ? $logoPath : $package->getUrl('build/images/logo.png'); ?>"
                        alt="Logo" class="header-logo"></a>
            <button type="button" class="languageButton" data-toggle="collapse" data-target="#languageOptions">
                <span class="activLanguage"><?php echo $this->t('{lifestyle:login:language_select_label}'); ?></span>
                <span class="icons icon-arrow-down" aria-hidden="true"></span>
            </button>
        </div>
        <div id="languageOptions" class="collapse">
            <p class="h3 text-center"><?php echo $this->t('{lifestyle:login:language_select}'); ?></p>
            <ul class="list-unstyled">
                <?php echo implode("\n", $languageSelect); ?>
            </ul>
        </div>
    </div>
</div>

<?php
if (!empty($this->data['htmlinject']['htmlContentPre'])) {
    foreach ($this->data['htmlinject']['htmlContentPre'] AS $c) {
        echo $c;
    }
}
