<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Entity;

use AppBundle\Database\Session as SessionInterface;
use Doctrine\ORM\EntityRepository;
use Doctrine\DBAL\Types\Type;
use DateTimeInterface;

/**
 * Class SessionRepository
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package AppBundle\Entity
 */
class SessionRepository extends EntityRepository implements SessionInterface
{

    /**
     * Returns list sessions matching useridentifier and not expired
     *
     * @param string $userIdentifier
     * @param DateTimeInterface $expire Default: now
     * @return Session[]
     */
    public function findByUserIdentifier($userIdentifier, DateTimeInterface $expire = null)
    {
        return $this
            ->createQueryBuilder('s')
            ->where('s.extra = :extra')
            ->andWhere('s.expire > :expire')
            ->setParameter('extra', $userIdentifier, Type::STRING)
            ->setParameter('expire', null !== $expire ? $expire : new \DateTime())
            ->getQuery()
            ->getResult();
    }
}