<?php

/**
 * Model request base class 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Request;

use AppBundle\Model\Base as ModelBase;
use AppBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Validator\Xml as XmlValidator;
use Sso\WebserviceBundle\Exception\InvalidContentException;

/**
 * Model request base class
 */
abstract class Base extends ModelBase
{

    /**
     * Api Manager
     * 
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Init model
     * 
     * @param \SimpleXMLElement $simpleXML
     */
    public function init(\SimpleXMLElement $simpleXML)
    {
        $validator = new XmlValidator();
        if (!$validator->validate($simpleXML, $validator->strToXml($this->_xmlAllowedElements()))) {
            $this->apiM->errors()->addErrors($validator->errors()->getErrors());
            throw new InvalidContentException('Invalid xml elements.');
        }
    }

    /**
     * Returns a xml-string with allowed structure
     * 
     * @return string
     */
    abstract protected function _xmlAllowedElements();
}
