<?php

/**
 * User response for showing user data 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Response\UserIdentifier;

/**
 * User-Identifier response
 */
class Validate extends Base
{

    /**
     * Returns response status
     * 
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->user ? true : false;
    }

    /**
     * Returns response message
     * 
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->user ? false : 'User not found';
    }

    /**
     * Build response body
     * 
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        if ($this->user) {
            $document = $this->apiM->responseBuilder()->document();
            $user = $document->createElement('UserType');
            $xmlContainer->appendChild($user);

            $user->appendChild($document->createTextElement('UserIdentifier', $this->user->getUserIdentifier()));
            if (null !== $this->user->getSessionLifetime()) {
                $user->appendChild($document->createTextElement('SessionLifetime', date('c', $this->user->getSessionLifetime())));
            }
        }
    }

}
