<?php
/**
 * Model factory class  
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Type;

use Sso\WebserviceBundle\Exception\Type\Base as BaseException;
use AppBundle\Api\Manager as ApiManager;
use AppBundle\Entity\User;

/**
 * Model factory class
 */
class Factory
{

    /**
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     *  Constructor
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param \DOMElement $userData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\User
     */
    public function user($userData, $validationGroups = null)
    {
        $model = new User($this->apiM->validator());
        try {
            $model->init($userData, $validationGroups, $this->apiM->errors());
        } catch (BaseException $exc) {
            
        }
        return $model;
    }

}
