<?php

/**
 * Steps Manager
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Api;

use JMS\Serializer\SerializerBuilder;
use Sso\Component\IdentifyServiceBundle\Node\Manager as NodeManager;

/**
 * Steps Manager
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Manager
{

    /**
     *
     * @var array
     */
    private $factory = array();

    /**
     * 
     * @return Manager
     */
    public static function create()
    {
        return new static();
    }

    /**
     * 
     * @return Request\Index
     */
    public function request()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Request\Index($this->serializer(), $this->nodeManager()));
    }

    /**
     * 
     * @return Response\Index
     */
    public function response()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Response\Index($this->serializer(), $this->nodeManager()));
    }

    /**
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }

    /**
     * 
     * @return NodeManager
     */
    private function nodeManager()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new NodeManager());
    }
}