<?php

/**
 * Steps User
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps User
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class UserType
{

    /**
     * Username
     * 
     * @Serializer\Groups({"Request::UserIdentifier::Get", "Request::UserIdentifier::Validate"})
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     * @var string
     */
    private $username;

    /**
     * Password
     * 
     * @Serializer\Groups({"Request::UserIdentifier::Get", "Request::UserIdentifier::Validate"})
     * @Serializer\SerializedName("Password")
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     * @var string
     */
    private $password;

    /**
     * UserIdentifier
     * 
     * @Serializer\Groups({"Request::UserIdentifier::Validate", "Response::UserIdentifier::Get", "Response::UserIdentifier::Validate"})
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     * @var string
     */
    private $userIdentifier;

    /**
     * SessionLifetime
     * 
     * @Serializer\Groups({"Response::UserIdentifier::Get", "Response::UserIdentifier::Validate"})
     * @Serializer\SerializedName("SessionLifetime")
     * @Serializer\Type("DateTime")
     * @Serializer\XmlElement(cdata=false)
     * @var \DateTime
     */
    private $sessionLifetime;

    /**
     * Set username
     * 
     * @param string $username
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = (string) $username;

        return $this;
    }

    /**
     * Get username
     * 
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Set password
     * 
     * @param string $password
     * @return UserType
     */
    public function setPassword($password)
    {
        $this->password = (string) $password;

        return $this;
    }

    /**
     * Get password
     * 
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Set UserIdentifier
     * 
     * @param string $userIdentifier
     * @return UserType
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = (string) $userIdentifier;

        return $this;
    }

    /**
     * Get UserIdentifier
     * 
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * Set SessionLifetime as unix timestamp
     *
     * @param \DateTime $sessionLifetime
     * @return User
     */
    public function setSessionLifetime(\DateTime $sessionLifetime = null)
    {
        $this->sessionLifetime = $sessionLifetime;

        return $this;
    }

    /**
     * Get SessionLifetime as unix timestamp
     *
     * @return \DateTime|null 
     */
    public function getSessionLifetime()
    {
        return $this->sessionLifetime;
    }

}