<?php
/**
 * Webservice request validation in annotation
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Configuration;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\ConfigurationAnnotation;

/**
 * Webservice request validation
 * 
 * @Annotation
 */
class WsValidate extends ConfigurationAnnotation
{
    /**
     * An array of validation methods.
     *
     * @var array
     */
    protected $validations = array();

    /**
     * Returns the array validation methods.
     *
     * @return array
     */
    public function getValidations()
    {
        return $this->validations;
    }

    /**
     * Sets request validations.
     *
     * @param array|string $validations A validation method or an array of validation methods
     */
    public function setValidations($validations)
    {
        $this->validations = is_array($validations) ? $validations : array($validations);
    }

    /**
     * Sets request validations.
     *
     * @param array|string $validation A validation method or an array of validation methods
     */
    public function setValue($validation)
    {
        $this->setValidations($validation);
    }

    /**
     * Returns the annotation alias name.
     *
     * @return string
     * @see ConfigurationInterface
     */
    public function getAliasName()
    {
        return 'wsValidate';
    }

    /**
     * Only one validation is allowed
     *
     * @return bool
     * @see ConfigurationInterface
     */
    public function allowArray()
    {
        return false;
    }
}