<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Security\Model\UserApplication;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Lifestyle\Sso\LaunchpadBundlelication
 * @package Lifestyle\Sso\LaunchpadBundle\Security\Model\UserApplication
 */
class Application
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("name")
     * @var string
     */
    private $name;

    /**
     * @Serializer\Type("ArrayCollection<App\Security\Model\UserApplication\Attribute>")
     * @Serializer\SerializedName("attributes")
     * @var Attribute[]
     */
    private $attributes;

    /**
     * @Serializer\Type("ArrayCollection<App\Security\Model\UserApplication\Role>")
     * @Serializer\SerializedName("roles")
     * @var Role[]
     */
    private $roles;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @return Role[]
     */
    public function getRoles()
    {
        return $this->roles;
    }
}
