<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\View\Model\User;

use Lifestyle\Sso\LaunchpadBundle\Security\User\SamlUser;

/**
 * Class ProfileMapper
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sso\LaunchpadBundle\View\Model\User
 */
class ProfileMapper
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     * ProfileMapper constructor.
     * @param Factory $factory
     */
    public function __construct(Factory $factory)
    {
        $this->factory = $factory;
    }

    /**
     * @param SamlUser $samlUser
     * @return Profile
     */
    public function mapFromSamlUser(SamlUser $samlUser): Profile
    {
        $profile = $this->factory->profile();

        $userData = $samlUser->getUserSamlData();
        $profile->setUserId((string)$userData->getUserGuid());
        $profile->setUsername((string)$userData->getUsername());
        $profile->setFirstName((string)$userData->getFirstname());
        $profile->setLastName((string)$userData->getLastname());
        $profile->setEmail((string)$userData->getEmail());
        $profile->setApplications((array)$userData->getApplications());

        return $profile;
    }
}
