<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Security\User;

use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Security\Core\Exception\UsernameNotFoundException;
use Symfony\Component\Security\Core\Exception\UnsupportedUserException;
use Lifestyle\Sso\LaunchpadBundle\Security\Model\UserData\User as UserDto;

/**
 * Class SamlUserProvider
 * @package Lifestyle\Sso\LaunchpadBundle\Security\User
 */
class SamlUserProvider implements UserProviderInterface
{
    /**
     * @param string $username
     * @return UserInterface|void
     */
    public function loadUserByUsername($username)
    {
        unset($username);
        // this provider can't be used with loadUserByUsername() as it pulls it's actual userinfo from the DTO
        // holding all user details we got from the IdP/SAML request.
        // So, lets just always throw the exception to ensure proper compatibility with the rest of the framework.
        throw new UsernameNotFoundException();
    }

    /**
     * Loads the user for the given username from the user DTO holding IdP/SAML details.
     * @param UserDto $user The user DTO
     * @return UserInterface
     * @throws UsernameNotFoundException if the user data is invalid
     */
    public function loadUserFromDto(UserDto $user)
    {
        $roles = [];

        if (null !== $user->getUserApplications() && count($user->getUserApplications()) > 0) {
            $roles[] = 'ROLE_USER';  // TODO: parse and map proper roles here
        }

        return new SamlUser($user, $roles);
    }

    /**
     * @param UserInterface $user
     * @return UserInterface|void
     */
    public function refreshUser(UserInterface $user)
    {
        unset($user);
        //not allowed
        throw new UnsupportedUserException();
    }

    /**
     * @param string $class
     * @return bool
     */
    public function supportsClass($class)
    {
        return $class === static::class;
    }
}
