<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace  Lifestyle\Sso\LaunchpadBundle\View\Model\User;

use Lifestyle\Sso\LaunchpadBundle\Security\Model\UserData\User;
use Lifestyle\Sso\LaunchpadBundle\Security\User\SamlUser;
use Faker\Provider\Uuid;
use PHPUnit\Framework\TestCase;
use PHPUnit\Framework\MockObject\MockObject;

/**
 * Class ProfileMapperTest
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package  Lifestyle\Sso\LaunchpadBundle\View\Model\User
 */
class ProfileMapperTest extends TestCase
{
    public function testMapFromSamlUser()
    {
        $factory = $this->getFactory();
        $mapper = new ProfileMapper($factory);

        $user = $this->getSamlUser();
        $profile = $mapper->mapFromSamlUser($user);

        $this->assertNotEmpty($user->getUserSamlData()->getUserGuid());
        $this->assertEquals($user->getUserSamlData()->getUserGuid(), $profile->getUserId());

        $this->assertNotEmpty($user->getUserSamlData()->getUsername());
        $this->assertEquals($user->getUserSamlData()->getUsername(), $profile->getUsername());

        $this->assertNotEmpty($user->getUserSamlData()->getFirstname());
        $this->assertEquals($user->getUserSamlData()->getFirstname(), $profile->getFirstname());

        $this->assertNotEmpty($user->getUserSamlData()->getLastname());
        $this->assertEquals($user->getUserSamlData()->getLastname(), $profile->getLastname());

        $this->assertNotEmpty($user->getUserSamlData()->getEmail());
        $this->assertEquals($user->getUserSamlData()->getEmail(), $profile->getEmail());
    }

    /**
     * @return MockObject|Factory
     */
    private function getFactory(): MockObject
    {
        $factory = $this
            ->getMockBuilder(Factory::class)
            ->setMethods(['profile'])
            ->getMock();

        $factory
            ->method('profile')
            ->willReturn(new Profile())
        ;

        return $factory;
    }

    /**
     * @return MockObject|SamlUser
     */
    private function getSamlUser(): MockObject
    {
        $samlUser = $this
            ->getMockBuilder(SamlUser::class)
            ->disableOriginalConstructor()
            ->getMock();

        $samlUser
            ->method('getUserSamlData')
            ->willReturn($this->getSamlUserData());

        return $samlUser;
    }

    /**
     * @return MockObject|User
     */
    private function getSamlUserData(): MockObject
    {
        $faker = \Faker\Factory::create();

        $userData = $this
            ->getMockBuilder(User::class)
            ->getMock();

        $userData
            ->method('getUserGuid')
            ->willReturn(Uuid::uuid());

        $userData
            ->method('getUsername')
            ->willReturn($faker->userName);

        $userData
            ->method('getFirstname')
            ->willReturn($faker->firstName);

        $userData
            ->method('getLastname')
            ->willReturn($faker->lastName);

        $userData
            ->method('getEmail')
            ->willReturn($faker->email);

        return $userData;
    }
}
