<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Security\Authentication\Provider;

use Lifestyle\Sso\LaunchpadBundle\Security\User\SamlUserProvider;
use Psr\Cache\CacheItemPoolInterface;
use Symfony\Component\Security\Core\Authentication\Provider\AuthenticationProviderInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Lifestyle\Sso\LaunchpadBundle\Security\Authentication\Token\SamlUserToken;

/**
 * Class SamlProvider
 * @package Lifestyle\Sso\LaunchpadBundle\Security\Authentication\Provider
 */
class SamlProvider implements AuthenticationProviderInterface
{
    /**
     * @var SamlUserProvider
     */
    private $userProvider;

    /**
     * @var CacheItemPoolInterface
     */
    private $cachePool;

    /**
     * SamlProvider constructor.
     * @param UserProviderInterface $userProvider
     * @param CacheItemPoolInterface $cachePool
     */
    public function __construct(
        UserProviderInterface $userProvider,
        CacheItemPoolInterface $cachePool
    ) {
        $this->userProvider = $userProvider;
        $this->cachePool = $cachePool;
    }

    /**
     * @param TokenInterface $token
     * @return SamlUserToken|null|TokenInterface
     */
    public function authenticate(TokenInterface $token)
    {
        $authenticatedToken = null;
        if (!($this->userProvider instanceof SamlUserProvider)) {
            throw new AuthenticationException('Unsupported userprovider.');
        }

        /** @var SamlUserToken $user */
        $user = $this->userProvider->loadUserFromDto($token->getUserDto());

        if (count($user->getRoles()) > 0) {
            $authenticatedToken = new SamlUserToken($user->getRoles());
            $authenticatedToken->setUser($user);
        }

        if (null === $authenticatedToken) {
            throw new AuthenticationException('SAML authentication failed.');
        }

        return $authenticatedToken;
    }

    /**
     * @param TokenInterface $token
     * @return bool
     */
    public function supports(TokenInterface $token)
    {
        return $token instanceof SamlUserToken;
    }
}
