<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Security\Authentication\Token;

use Symfony\Component\Security\Core\Authentication\Token\AbstractToken;
use Lifestyle\Sso\LaunchpadBundle\Security\Model\UserApplication\Application as UserApplication;
use Lifestyle\Sso\LaunchpadBundle\Security\Model\UserData\User as UserDto;

/**
 * Class SamlUserToken
 * @package Lifestyle\Sso\LaunchpadBundle\Security\Authentication\Token
 */
class SamlUserToken extends AbstractToken
{
    /**
     * @var string
     */
    public $userName;

    /**
     * @var string
     */
    public $userId;

    /**
     * @var string
     */
    public $email;

    /**
     * @var string
     */
    public $firstname;

    /**
     * @var string
     */
    public $lastname;

    /**
     * @var UserApplication
     */
    public $appData;

    /**
     * @var UserDto
     */
    public $userData;

    /**
     * SamlUserToken constructor.
     * @param array $roles
     */
    public function __construct(array $roles = array())
    {
        parent::__construct($roles);

        // If the user has roles, consider it authenticated
        $this->setAuthenticated(count($roles) > 0);
    }

    /**
     * @return mixed The user credentials
     */
    public function getCredentials()
    {
        return '';
    }

    /**
     * @return UserDto
     */
    public function getUserDto()
    {
        return $this->userData;
    }

    /**
     * @see __unserialize()
     */
    public function __serialize(): array
    {
        return [
            $this->userName,
            $this->userId,
            $this->email,
            $this->firstname,
            $this->lastname,
            $this->appData,
            $this->userData,
            parent::__serialize(),
        ];
    }

    /**
     * @param array $data
     * @see __serialize()
     */
    public function __unserialize(array $data): void
    {
        [
            $this->userName,
            $this->userId,
            $this->email,
            $this->firstname,
            $this->lastname,
            $this->appData,
            $this->userData,
            $parentData
        ] = $data;
        parent::__unserialize($parentData);
    }
}
