<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Configuration;

/**
 * Class LaunchpadConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sso\LaunchpadBundle\Configuration
 */
class LaunchpadConfiguration
{
    /**
     * @var array
     */
    private $configuration;

    /**
     * LaunchpadConfiguration constructor.
     * @param array $configuration
     */
    public function __construct(array $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * Returns configuration build by Symfonys treebuilder
     *
     * @return array
     */
    public function getConfiguration(): array
    {
        return $this->configuration;
    }
}
