<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Security\Configuration;

/**
 * Class SamlConfig
 * @package Lifestyle\Sso\LaunchpadBundle\Security\Configuration
 */
final class SamlConfig
{
    /**
     * @var string
     */
    private $spName = 'ls-sso-idp';

    /**
     * @var string
     */
    private $idpAppName = '';

    /**
     * @return string
     */
    public function getIdpAppName()
    {
        return $this->idpAppName;
    }

    /**
     * @param string $idpAppName
     * @return SamlConfig
     */
    public function setIdpAppName($idpAppName)
    {
        $this->idpAppName = $idpAppName;
        return $this;
    }

    /**
     * @return string
     */
    public function getSpName()
    {
        return $this->spName;
    }

    /**
     * @param string $spName
     * @return SamlConfig
     */
    public function setSpName($spName)
    {
        $this->spName = $spName;

        return $this;
    }
}
