<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Security\Services;

use Lifestyle\Sso\LaunchpadBundle\Security\Configuration\SamlConfig;
use SimpleSAML\Auth\Simple as SimpleSamlAuthSimple;

/**
 * Class SamlService
 * @package Lifestyle\Sso\LaunchpadBundle\Security\Services
 */
class SamlService
{
    /**
     * @var SamlConfig
     */
    private $samlConfig;

    /**
     * SamlService constructor.
     * @param SamlConfig $config
     */
    public function __construct(SamlConfig $config)
    {
        $this->samlConfig = $config;
    }

    /**
     * @return SimpleSamlAuthSimple
     */
    public function getSimpleSaml()
    {
        return new SimpleSamlAuthSimple($this->samlConfig->getSpName());
    }
}
