<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace  Lifestyle\Sso\LaunchpadBundle\View\Model\User;

use PHPUnit\Framework\TestCase;

/**
 * Class ProfileTest
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package  Lifestyle\Sso\LaunchpadBundle\View\Model\User
 */
class ProfileTest extends TestCase
{
    public function testProfile()
    {
        $faker = \Faker\Factory::create();

        $userId = md5($faker->text);
        $email = $faker->email;
        $username = $faker->userName;
        $firstName = $faker->firstName;
        $lastName = $faker->lastName;

        $applications = array_fill(0, mt_rand(1, 10), true);
        array_walk($applications, function(&$application) use ($faker) {
            $application = $faker->word;
        });
        $applications = array_unique($applications);

        $profile = new Profile();
        $profile->setUserId($userId);
        $profile->setUsername($username);
        $profile->setEmail($email);
        $profile->setFirstName($firstName);
        $profile->setLastName($lastName);
        $profile->setApplications($applications);

        $this->assertEquals($userId, $profile->getUserId());
        $this->assertEquals($username, $profile->getUsername());
        $this->assertEquals($email, $profile->getEmail());
        $this->assertEquals($firstName, $profile->getFirstName());
        $this->assertEquals($lastName, $profile->getLastName());
        $this->assertEquals($applications, $profile->getApplications());
    }
}
