<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Controller;

use Lifestyle\Sso\LaunchpadBundle\Configuration\LaunchpadConfiguration;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Lifestyle\Sso\LaunchpadBundle\Security\Services\SamlService;

/**
 * Class IndexController
 * @package Lifestyle\Sso\LaunchpadBundle\Controller
 */
class IndexController extends AbstractController
{
    /**
     * @var LaunchpadConfiguration
     */
    private $launchpadConfiguration;

    /**
     * @var SamlService
     */
    private $samlService;

    /**
     * IndexController constructor.
     * @param LaunchpadConfiguration $launchpadConfiguration
     * @param SamlService $samlService
     */
    public function __construct(LaunchpadConfiguration $launchpadConfiguration, SamlService $samlService)
    {
        $this->launchpadConfiguration = $launchpadConfiguration;
        $this->samlService = $samlService;
    }

    /**
     * @Route("/", name="index_index")
     */
    public function index()
    {
        return $this->render('@LifestyleSsoLaunchpad/index/index.html.twig');
    }

    /**
     * @Route("/logout", name="index_logout")
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function logout()
    {
        if ($this->samlService->getSimpleSaml()->isAuthenticated()) {
            $this->samlService->getSimpleSaml()->logout();
        }

        return $this->redirect('/');
    }

    /**
     * @Route("/ping", name="index_ping")
     * @return Response
     */
    public function ping()
    {
        if ($this->samlService->getSimpleSaml()->isAuthenticated()) {
            return new JsonResponse(null, Response::HTTP_NO_CONTENT);
        }
        return new JsonResponse(null, Response::HTTP_FORBIDDEN);
    }

    /**
     * @Route("/configuration")
     * @return Response
     */
    public function configuration()
    {
        $userApplications = (array)$this->getUser()->getUserSamlData()->getApplications();
        $configuration = $this->launchpadConfiguration->getConfiguration();
        $configuration['applications'] = array_intersect_key($configuration['applications'], array_flip($userApplications));
        return new JsonResponse($configuration);
    }
}
