<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Controller;

use Lifestyle\Sso\LaunchpadBundle\Security\Services\SamlService;
use Lifestyle\Sso\LaunchpadBundle\View\Model\User\ProfileMapper;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class UserController
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sso\LaunchpadBundle\Controller
 * @Route("/user")
 */
class UserController extends AbstractController
{
    /**
     * @var SamlService
     */
    private $samlService;

    /**
     * @var ProfileMapper
     */
    private $profileMapper;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * UserController constructor.
     * @param SamlService $samlService
     * @param ProfileMapper $profileMapper
     * @param SerializerInterface $serializer
     */
    public function __construct(SamlService $samlService, ProfileMapper $profileMapper, SerializerInterface $serializer)
    {
        $this->samlService = $samlService;
        $this->profileMapper = $profileMapper;
        $this->serializer = $serializer;
    }

    /**
     * @Route("/profile")
     * @return JsonResponse
     */
    public function profile()
    {
        $userProfile = $this->profileMapper->mapFromSamlUser($this->getUser());
        return new JsonResponse($this->serializer->serialize($userProfile, 'json'), 200, [], true);
    }
}
