<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sso\LaunchpadBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * Generates the configuration tree builder.
     *
     * @return \Symfony\Component\Config\Definition\Builder\TreeBuilder The tree builder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('lifestyle_sso_launchpad');
        $rootNode = method_exists(TreeBuilder::class, 'getRootNode') ? $treeBuilder->getRootNode() : $treeBuilder->root('monolog');

        $rootNode
            ->children()
                ->arrayNode('applications')
                    ->isRequired()
                    ->useAttributeAsKey('name')
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('url')->isRequired()->cannotBeEmpty()->end()
                            ->scalarNode('img')->isRequired()->cannotBeEmpty()->end()
                            ->scalarNode('title')->isRequired()->cannotBeEmpty()->end()
                            ->scalarNode('description')->isRequired()->cannotBeEmpty()->end()
                            ->arrayNode('groups')->scalarPrototype()->isRequired()->cannotBeEmpty()->end()->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('application_groups')
                    ->isRequired()
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('selector')->isRequired()->cannotBeEmpty()->end()
                            ->scalarNode('title')->isRequired()->cannotBeEmpty()->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('application_filter')
                    ->isRequired()
                    ->children()
                        ->booleanNode('enabled')->isRequired()->end()
                        ->integerNode('min_applications')->isRequired()->end()
                    ->end()
                ->end()
                ->arrayNode('application_icons')
                    ->isRequired()
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('selector')->isRequired()->cannotBeEmpty()->end()
                            ->scalarNode('src')->isRequired()->cannotBeEmpty()->end()
                        ->end()
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
