<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sso\LaunchpadBundle\Security\Handler;

use Lifestyle\Sso\LaunchpadBundle\Security\Exceptions\InvalidUserObjectException;
use Lifestyle\Sso\LaunchpadBundle\Security\Exceptions\SamlAuthExceptionInterface;
use Lifestyle\Sso\LaunchpadBundle\Security\Exceptions\UserNotAuthenticatedExceptionInterface;
use Lifestyle\Sso\LaunchpadBundle\Security\User\SamlUser;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

/**
 * Class UserHandler
 * @package Lifestyle\Sso\LaunchpadBundle\Security\Handler
 */
class UserHandler implements UserHandlerInterface
{
    /**
     * @var TokenStorageInterface
     */
    private $securityToken;

    /**
     * UserHandler constructor.
     * @param TokenStorageInterface $securityToken
     */
    public function __construct(TokenStorageInterface $securityToken)
    {
        $this->securityToken = $securityToken;
    }

    /**
     * @return SamlUser
     * @throws SamlAuthExceptionInterface
     */
    public function getSamlUser()
    {
        if (null === $token = $this->securityToken->getToken()) {
            throw new UserNotAuthenticatedExceptionInterface();
        }

        if (!is_object($user = $token->getUser())) {
            // e.g. anonymous authentication
            throw new UserNotAuthenticatedExceptionInterface();
        }

        if (!($user instanceof SamlUser)) {
            throw new InvalidUserObjectException(sprintf(
                'SAML-user should be instance of "%s" but is "%s"',
                SamlUser::class,
                get_class($user)
            ));
        }

        return $user;
    }
}
