# Life-Style SSO-Launchpad Application

## Create a new launchpad application for your SSO project 

### Download

```shell script
composer create-project ssh://git@stash.life-style.de:7999/sso/ls-sso-launchpad-app.git lauchpad-app
```
If `composer create-project` does not work because of ssl-cert or other problems, clone the repository and remove `.git` folder:

```shell script
git clone ssh://git@stash.life-style.de:7999/sso/ls-sso-launchpad-app.git lauchpad-app
rm -rf lauchpad-app/.git
```

## Prepare Application

```shell script
cd lauchpad-app
composer install
npm install
npm run build
```

## Configure Application

```shell script
cp .env.dist .env
```

Edit `.env` file and adjust to your needs. Don't forget to change the secret!

## Prepare database

Create a database (encoding: utf8mb4/utf8mb4_bin) and run doctrine migrations:

```shell script
php bin/console doctrine:migrations:migrate
```

## Configure SAML

This is the most difficult part of the installation. The configuration files should be placed in `config/saml/YOUR_ENV`. There is an example in `config/saml/dev` to give you an idea how it may look like. Please read the [documentation of simpleSAMLphp](https://simplesamlphp.org/docs/stable/simplesamlphp-sp).

In most cases you have to do the following:

Edit the `config/saml/dev/config.php` and adjust at least

- secretsalt
- auth.adminpassword
- store.sql.dsn
- store.sql.username
- store.sql.password

Create a certificate:

```shell script
cd config/saml/dev/cert
rm saml.*
openssl req -newkey rsa:3072 -new -x509 -days 3652 -nodes -out saml.crt -keyout saml.pem
```

Get your IdPs metadata at something like `https://login.your-project.com/saml2/idp/metadata.php?output=xhtml`, if it is a simpleSAMLphp IdP and replace the metadata in `config/saml/dev/metadata/saml20-idp-remote.php` with php-code from your IdP.  

Add your IdP to the authentication source list at `config/saml/dev/authsources.php`.

After you have configured your webserver (see instructions below), open your applications metadata at something like `https://launchpad.your-project.com/sso/module.php/saml/sp/metadata.php/ls-sso-idp?output=xhtml`. Add the php-code to your IdPs configuration, that means you have to open the IdPs project and add the lines to the IdPs configuration NOT this projects configuration! More details can be found at the [simpleSAMLphp documentation](https://simplesamlphp.org/docs/stable/)

## Prepare For Local Development On Code Base - NOT Needed For Your Project

### Checkout Source Code 

```shell script
git clone ssh://git@stash.life-style.de:7999/sso/ls-sso-launchpad-app.git lauchpad-app
```

### Prepare

```shell script
    php composer.phar install
    php bin/console doctrine:migrations:migrate
    npm install
    cd ./node_modules/eslint-config-lifestyle && npm run setup -- es2015 && cd ../..
    cd ./node_modules/stylelint-config-lifestyle && npm run setup -- scss && cd ../..
```

Read: https://intranet.life-style.de/pages/viewpage.action?pageId=39190657
Read: https://intranet.life-style.de/pages/viewpage.action?pageId=39190661

Config for console command .env

    DATABASE_URL=mysql:host=127.0.0.1;dbname=ls-sso-launchpad
    DATABASE_USER=root
    DATABASE_PASSWORD=***


## Configure Apache Webserver

Vhosts for apache 2.2

```
    Alias /sso /absolute/path/to/app/ls-sso-launchpad/vendor/simplesamlphp/simplesamlphp/www/
    <Directory /absolute/path/to/app/ls-sso-launchpad/vendor/simplesamlphp/simplesamlphp/www>
      Options Includes FollowSymLinks
      AllowOverride All
      Order allow,deny
      Allow from all
    </Directory>

    SetEnv SIMPLESAMLPHP_CONFIG_DIR /absolute/path/to/app/ls-sso-launchpad/config/saml/dev
```
  
Vhosts for apache 2.4

```
    Alias /sso /absolute/path/to/app/ls-sso-launchpad/vendor/simplesamlphp/simplesamlphp/www
    <Directory /absolute/path/to/app/ls-sso-launchpad/vendor/simplesamlphp/simplesamlphp/www>
      Options Includes FollowSymLinks
      AllowOverride All
      Require all granted
    </Directory>
  
    SetEnv SIMPLESAMLPHP_CONFIG_DIR /absolute/path/to/app/ls-sso-launchpad/config/saml/dev
```
