<?php
/*
 * The configuration of SimpleSAMLphp
 */

$appPath = dirname(dirname(dirname(__DIR__)));

$config = array(
    'baseurlpath' => 'sso/',
    'certdir' => __DIR__ . '/cert/',
    'loggingdir' => $appPath . '/var/log/',
    'datadir' => $appPath . '/var/cache/',
    'tempdir' => '/tmp/simplesaml',
    'technicalcontact_name' => 'Administrator',
    'technicalcontact_email' => 'info@life-style.de',
    'secretsalt' => 'defaultsecretsalt',
    'auth.adminpassword' => 'your-secret',
    'admin.protectindexpage' => true,
    'admin.protectmetadata' => true,
    'admin.checkforupdates' => true,
    'trusted.url.domains' => array(),
    'trusted.url.regex' => false,
    'enable.http_post' => false,
    'debug' => array(
        'saml' => true,
        'backtraces' => true,
        'validatexml' => false,
    ),
    'showerrors' => true,
    'errorreporting' => true,
    'logging.level' => SimpleSAML\Logger::NOTICE,
    'logging.handler' => 'file',
    'logging.facility' => defined('LOG_LOCAL5') ? constant('LOG_LOCAL5') : LOG_USER,
    'logging.processname' => 'simplesamlphp',
    'logging.logfile' => 'simplesamlphp.log',
    'statistics.out' => array(
        array(
            'class' => 'core:Log',
            'level' => 'notice',
        ),
    ),
    'proxy' => null,
    'proxy.auth' => false,
    'enable.saml20-idp' => false,
    'enable.shib13-idp' => false,
    'enable.adfs-idp' => false,
    'enable.wsfed-sp' => false,
    'enable.authmemcookie' => false,
    'default-wsfed-idp' => 'urn:federation:pingfederate:localhost',
    'shib13.signresponse' => true,
    'session.duration' => 8 * (60 * 60), // 8 hours.
    'session.datastore.timeout' => (4 * 60 * 60), // 4 hours
    'session.state.timeout' => (60 * 60), // 1 hour
    'session.cookie.name' => 'SAMLSessionID',
    'session.cookie.lifetime' => 0,
    'session.cookie.path' => '/',
    'session.cookie.domain' => null,
    'session.cookie.secure' => false,
    'session.phpsession.cookiename' => 'SAML',
    'session.phpsession.savepath' => null,
    'session.phpsession.httponly' => true,
    'session.authtoken.cookiename' => 'SAMLAuthToken',
    'session.rememberme.enable' => false,
    'session.rememberme.checked' => false,
    'session.rememberme.lifetime' => (14 * 86400),
    'language.available' => array(
        'en',
        'de',
    ),
    'language.rtl' => array('ar', 'dv', 'fa', 'ur', 'he'),
    'language.default' => 'en',
    'language.parameter.name' => 'language',
    'language.parameter.setcookie' => true,
    'language.cookie.name' => 'language',
    'language.cookie.domain' => null,
    'language.cookie.path' => '/',
    'language.cookie.secure' => false,
    'language.cookie.httponly' => true,
    'language.cookie.lifetime' => (60 * 60 * 24 * 900),
    'language.i18n.backend' => 'SimpleSAMLphp',
    'attributes.extradictionary' => null,
    'theme.use' => 'default',
    'template.auto_reload' => false,
    'idpdisco.enableremember' => true,
    'idpdisco.rememberchecked' => true,
    'idpdisco.validate' => true,
    'idpdisco.extDiscoveryStorage' => null,
    'idpdisco.layout' => 'dropdown',
    'authproc.sp' => array(
        90 => 'core:LanguageAdaptor',
    ),
    'metadata.sources' => array(
        array('type' => 'flatfile', 'directory' => __DIR__ . '/metadata'),
    ),
    'metadata.sign.enable' => false,
    'metadata.sign.privatekey' => null,
    'metadata.sign.privatekey_pass' => null,
    'metadata.sign.certificate' => null,
    'store.type' => 'sql',
    'store.sql.dsn' => 'mysql:host=localhost;dbname=db_name',
    'store.sql.username' => 'db_user',
    'store.sql.password' => 'db_password',
    'store.sql.prefix' => 'saml',
);
