<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class Session
 * @package App\Entity
 *
 * @ORM\Table(name="sessions")
 * @ORM\Entity
 */
class Session
{
    /**
     * @ORM\Column(name="sess_id", type="binary", length=128, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @var string
     */
    private $keyId;

    /**
     * @ORM\Column(name="sess_data", type="blob", length=65535, nullable=false)
     * @var string
     */
    private $data;

    /**
     * @ORM\Column(name="sess_time", type="integer", nullable=false, options={"unsigned"=true})
     * @var integer
     */
    private $time;

    /**
     * @ORM\Column(name="sess_lifetime", type="integer", nullable=false)
     * @var integer
     */
    private $lifetime;

    /**
     * Set id
     * @param string $keyId
     * @return Session
     */
    public function setId($keyId)
    {
        $this->keyId = $keyId;

        return $this;
    }

    /**
     * Get id
     * @return string
     */
    public function getId()
    {
        return $this->keyId;
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param mixed $data
     * @return Session
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Set time
     * @param integer $time
     * @return Session
     */
    public function setTime($time)
    {
        $this->time = $time;

        return $this;
    }

    /**
     * Get time
     * @return integer
     */
    public function getTime()
    {
        return $this->time;
    }

    /**
     * Set lifetime
     * @param integer $lifetime
     * @return Session
     */
    public function setLifetime($lifetime)
    {
        $this->lifetime = $lifetime;

        return $this;
    }

    /**
     * Get lifetime
     * @return integer
     */
    public function getLifetime()
    {
        return $this->lifetime;
    }
}
