# Life-Style SSO-Launchpad Application

## Create a new launchpad application for your SSO project 

### Create Application

```shell script
composer create-project ssh://git@stash.life-style.de:7999/sso/ls-sso-launchpad-app.git lauchpad-app
```
If `composer create-project` does not work because of ssl-cert or other problems, clone the repository and remove `.git` folder:

```shell script
git clone ssh://git@stash.life-style.de:7999/sso/ls-sso-launchpad-app.git lauchpad-app
rm -rf lauchpad-app/.git
```

### Prepare Application

```shell script
cd lauchpad-app
composer install
npm install
npm run build
```

### Configure Application

```shell script
cp .env .env.local
```

Edit `.env.local` file and adjust to your needs. Don't forget to change the secret!

### Prepare database

Create a database (encoding: utf8mb4/utf8mb4_bin) and run doctrine migrations:

```
CREATE USER IF NOT EXISTS 'sso_launchpad'@'%' IDENTIFIED BY 'sso_launchpad';
CREATE DATABASE sso_launchpad_app CHARACTER SET = 'utf8mb4' COLLATE = 'utf8mb4_bin';
REVOKE ALL PRIVILEGES, GRANT OPTION FROM 'sso_launchpad'@'%';
GRANT ALL PRIVILEGES ON sso_launchpad_app.* TO 'sso_launchpad'@'%';
```

```shell script
php bin/console doctrine:migrations:migrate
```

### Configure SAML

This is the most difficult part of the installation. The configuration files should be placed in `config/saml/YOUR_ENV`. There is an example in `config/saml/dev` to give you an idea how it may look like. Please read the [documentation of simpleSAMLphp](https://simplesamlphp.org/docs/stable/simplesamlphp-sp).

In most cases you have to do the following:

Edit or copy `config/saml/dev/config.php` and adjust at least

- secretsalt
- auth.adminpassword
- store.sql.dsn
- store.sql.username
- store.sql.password

Create a certificate:

```shell script
cd config/saml/dev/cert
rm saml.*
openssl req -newkey rsa:3072 -new -x509 -days 3652 -nodes -out saml.crt -keyout saml.pem
```

Get your IdPs metadata at something like `https://login.your-project.com/saml2/idp/metadata.php?output=xhtml`, if it is a simpleSAMLphp IdP and replace the metadata in `config/saml/dev/metadata/saml20-idp-remote.php` with php-code from your IdP metadata page.  

Add your IdP to the authentication source list at `config/saml/dev/authsources.php`.

After you have configured your webserver (see instructions below), open your applications metadata at something like `https://launchpad.your-project.com/sso/module.php/saml/sp/metadata.php/ls-sso-idp?output=xhtml`. Add the php-code to your IdPs configuration, that means you have to open the IdPs project and add the lines to the IdPs configuration NOT this projects configuration! More details can be found at the [simpleSAMLphp documentation](https://simplesamlphp.org/docs/stable/)

### Configure Webserver

Configure your webserver as described at the [Symfony documentation](https://symfony.com/doc/4.3/setup/web_server_configuration.html).

#### Configure Apache

In addition to Symfonys standard Apache configuration the following must be added to your vhosts configuration:
(env var PROJECT_ROOT is needed when configuration is symlinked, not necessarily for development)

```
    Alias /sso /absolute/path/to/app/ls-sso-launchpad/vendor/simplesamlphp/simplesamlphp/www
    <Directory /absolute/path/to/app/ls-sso-launchpad/vendor/simplesamlphp/simplesamlphp/www>
      Options Includes FollowSymLinks
      AllowOverride All
      Require all granted
    </Directory>
  
    SetEnv SIMPLESAMLPHP_CONFIG_DIR /absolute/path/to/app/ls-sso-launchpad/config/saml/dev
    SetEnv PROJECT_ROOT /absolute/path/to/app/ls-sso-launchpad
```

#### Configure Nginx

Will follow soon ...

### Git

Don't forget to update this README file to your project and add files to a new git repository!


## Prepare For Local Development On Code Base - NOT Needed For Your Project

### Checkout Source Code 

```shell script
git clone ssh://git@stash.life-style.de:7999/sso/ls-sso-launchpad-app.git lauchpad-app
```

### Prepare

```shell script
    composer install
    php bin/console doctrine:migrations:migrate
    npm install
    cd ./node_modules/eslint-config-lifestyle && npm run setup -- es2015 && cd ../..
    cd ./node_modules/stylelint-config-lifestyle && npm run setup -- scss && cd ../..
```

- Read: https://intranet.life-style.de/pages/viewpage.action?pageId=39190657
- Read: https://intranet.life-style.de/pages/viewpage.action?pageId=39190661

Config your local environment `.env.local`, copy from `.env`:

```
DATABASE_URL=mysql:host=127.0.0.1;dbname=ls-sso-launchpad
DATABASE_USER=root
DATABASE_PASSWORD=***
```
