<?php
error_reporting(E_ERROR);
$appRootPath = dirname(dirname(dirname(__DIR__)));

$config = [
    'baseurlpath' => '/saml/',
    'certdir' => __DIR__.'/certs/',
    'loggingdir' => $appRootPath . '/../logs/',
    'datadir' => $appRootPath . '/../cache/',
    'tempdir' => '/tmp/simplesaml',
    'debug' => true,
    'showerrors' => true,
    'errorreporting' => true,
    'debug.validatexml' => false,
    'auth.adminpassword' => '123',
    'admin.protectindexpage' => false,
    'admin.protectmetadata' => false,
    'secretsalt' => 'bHzV7gwWbnmMAh8HwbBDpQndFbW67',
    'technicalcontact_name' => 'Administrator',
    'technicalcontact_email' => 'na@example.org',
    'timezone' => null,
    'logging.level' => SimpleSAML_Logger::NOTICE,
    'logging.handler' => 'file',
    'logging.facility' => defined('LOG_LOCAL5') ? constant('LOG_LOCAL5') : LOG_USER,
    'logging.processname' => 'simplesamlphp',
    'logging.logfile' => 'simplesamlphp.log',
    'statistics.out' => [],
    'enable.saml20-idp' => false,
    'enable.shib13-idp' => false,
    'enable.adfs-idp' => false,
    'enable.wsfed-sp' => false,
    'enable.authmemcookie' => false,
    'session.duration' => 8 * (60 * 60), // 8 hours.
    'session.datastore.timeout' => (4 * 60 * 60), // 4 hours
    'session.state.timeout' => (60 * 60), // 1 hour
    'session.cookie.name' => 'SimpleSAMLSessionID',
    'session.cookie.lifetime' => 0,
    'session.cookie.path' => '/',
    'session.cookie.domain' => null,
    'session.cookie.secure' => false,
    'enable.http_post' => false,
    'session.phpsession.cookiename' => null,
    'session.phpsession.savepath' => null,
    'session.phpsession.httponly' => true,
    'session.authtoken.cookiename' => 'SimpleSAMLAuthToken',
    'session.rememberme.enable' => false,
    'session.rememberme.checked' => false,
    'session.rememberme.lifetime' => (14 * 86400),
    'language.available' => [
        'en', 'no', 'nn', 'se', 'da', 'de', 'sv', 'fi', 'es', 'fr', 'it', 'nl', 'lb', 'cs',
        'sl', 'lt', 'hr', 'hu', 'pl', 'pt', 'pt-br', 'tr', 'ja', 'zh', 'zh-tw', 'ru', 'et',
        'he', 'id', 'sr', 'lv', 'ro', 'eu'
    ],
    'language.rtl' => ['ar', 'dv', 'fa', 'ur', 'he'],
    'language.default' => 'en',
    'language.parameter.name' => 'language',
    'language.parameter.setcookie' => true,
    'language.cookie.name' => 'language',
    'language.cookie.domain' => null,
    'language.cookie.path' => '/',
    'language.cookie.lifetime' => (60 * 60 * 24 * 900),
    'attributes.extradictionary' => null,
    'theme.use' => 'default',
    'default-wsfed-idp' => 'urn:federation:pingfederate:localhost',
    'idpdisco.enableremember' => true,
    'idpdisco.rememberchecked' => true,
    'idpdisco.validate' => true,
    'idpdisco.extDiscoveryStorage' => null,
    'idpdisco.layout' => 'dropdown',
    'shib13.signresponse' => true,
    'authproc.idp' => [
        30 => 'core:LanguageAdaptor',
        45 => array(
            'class' => 'core:StatisticsWithAttribute',
            'attributename' => 'realm',
            'type' => 'saml20-idp-SSO',
        ),
        50 => 'core:AttributeLimit',
        99 => 'core:LanguageAdaptor',
    ],
    'authproc.sp' => [
        90 => 'core:LanguageAdaptor',
    ],
    'metadata.sources' => [
        ['type' => 'flatfile', 'directory' => __DIR__ . '/metadata']
    ],
    'store.type' => 'sql',
    'store.sql.dsn' => getenv('DATABASE_URL'),
    'store.sql.username' => getenv('DATABASE_USER'),
    'store.sql.password' => (false === getenv('DATABASE_PASSWORD') ? null : getenv('DATABASE_PASSWORD')),
    'store.sql.prefix' => 'saml',
    'metadata.sign.enable' => false,
    'metadata.sign.privatekey' => null,
    'metadata.sign.privatekey_pass' => null,
    'metadata.sign.certificate' => null,
    'proxy' => null,
    'trusted.url.domains' => [],
];
