#!/usr/bin/env bash

COMPOSER=`which composer`

set -e

EXCLUDE_FILES=""
if [ "$1" == "dev" ]; then
    . ebscripts/envvars_dev.sh
    EXCLUDE_FILES="${EXCLUDE_FILES} ebscripts/envvars.sh"
else
    . ebscripts/envvars.sh
    EXCLUDE_FILES="${EXCLUDE_FILES} ebscripts/envvars_dev.sh"
fi

cd $(cd $(dirname $0); echo $PWD)

#
# Export your php-binary to variable PHP to use multiple php versions
#
if [ "" == "${PHP}" ]; then
    PHP=`which php`
elif [ "" != "${COMPOSER}" ]; then
    COMPOSER="${PHP} ${COMPOSER}"
fi

if [ "" == "${COMPOSER}" ]; then

    if [ ! -f "composer.phar" ]; then

        COMPOSER_EXPECTED_SIGNATURE=$(curl -s https://composer.github.io/installer.sig)
        ${PHP} -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
        COMPOSER_ACTUAL_SIGNATURE=$(${PHP} -r "echo hash_file('SHA384', 'composer-setup.php');")

        if [ "${COMPOSER_EXPECTED_SIGNATURE}" != "${COMPOSER_ACTUAL_SIGNATURE}" ]
        then
            >&2 echo 'ERROR: Invalid composer installer signature'
            rm composer-setup.php
            exit 1
        fi

        ${PHP} composer-setup.php --quiet --1
        rm composer-setup.php
    fi

    COMPOSER="${PHP} ./composer.phar"
    ${COMPOSER} self-update --1
fi

rm -rf vendor.tmp
if [ -d vendor ]; then
    mv vendor vendor.tmp

    # Move vendor folder back
    function cleanup {
        if [ -d vendor.tmp ]; then
            rm -rf vendor
            mv vendor.tmp vendor
        fi
        rm -f web/index.php
    }
    trap cleanup EXIT ERR SIGINT SIGTERM
fi

if [ "${SYMFONY_DEBUG}" == "1" ]; then
    ${COMPOSER} install --no-scripts
else
    ${COMPOSER} install --no-scripts --no-dev
fi

# Create aws entry point
cp web/app_${SYMFONY_ENV}.php web/index.php

# Clean up before zip file is build
if [ -d var ]; then
    find var -type f -not -name ".gitkeep" -delete
fi
if [ -d app/cache ]; then
    find app/cache -type f -not -name ".gitkeep" -delete
fi
if [ -d app/logs ]; then
    find app/cache -type f -not -name ".gitkeep" -delete
fi

# Build zip file for deployment
mkdir -p build
rm -f build/eb.zip
zip -q -r build/eb.zip \
.ebextensions \
app \
aws \
bin \
ebscripts \
src \
srcBundles \
var \
vendor \
web \
README.md \
composer.json \
composer.lock \
index.html \
--symlinks \
\
--exclude \
*.DS_Store* \
app/config/*_lsd.yml \
app/config/*_mh.yml \
app/config/*_of.yml \
app/config/*_sb.yml \
app/config/*_staging.yml \
app/config/*_test.yml \
app/test \
web/.htaccess \
web/app*.php \
${EXCLUDE_FILES}

if [ "$1" == "dev" ]; then
    echo "Zip file prepared for deployment with debug options turned ON."
    echo "This Version should only be used for testing! Environment is set to SYMFONY_ENV=aws_dev."
else
    echo "Zip file prepared for deployment with debug options turned OFF."
    echo "This Version can be used for production and testing! Environment is set to SYMFONY_ENV=aws_prod."
fi
echo "use 'eb deploy --staged my-instance' to deploy application now or upload file build/eb.zip to your EBS versions"
