#!/usr/bin/env bash
set -e

#################################################################
#
# This script should only be executed within the leader instance!
#
#################################################################

. /opt/elasticbeanstalk/support/envvars

cd $(cd $(dirname $0); echo $PWD)
test -x envvars.sh && . envvars.sh
test -x envvars_dev.sh && . envvars_dev.sh
cd ..
set -xe

echo "Application update database start..."

#
# Ensure that database is up2date before application is deployed
#
php app/console doctrine:migrations:migrate --no-interaction --em=ReadWrite --configuration=app/config/migrations/read_write.yml
php app/console doctrine:migrations:migrate --no-interaction --em=Backend --configuration=app/config/migrations/backend.yml
php app/console doctrine:migrations:migrate --no-interaction --em=ServiceProvider --configuration=app/config/migrations/service_provider.yml
php app/console doctrine:migrations:migrate --no-interaction --em=Webservice --configuration=app/config/migrations/webservice.yml

echo "Application update database done."
