<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\ActivityLogBundle\Entity;

use Doctrine\ORM\Id\UuidGenerator;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;

/**
 * Class UserActionLog
 * @package LifeStyle\ActivityLogBundle\Entity
 *
 * @ORM\Entity
 * @ORM\Table(name="saml_user_action_log_data")
 */
class UserActionLogData
{
    /**
     * @ORM\Column(name="id", type="uuid_binary")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @var Uuid
     */
    private $keyId;

    /**
     * @ORM\OneToOne(targetEntity="UserActionLog", inversedBy="userActionLogData")
     * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
     * @var UserActionLog
     */
    private $userActionLog;

    /**
     * "TEXT" field, size=65535
     * @ORM\Column(name="request_data", type="text", nullable=true)
     * @var string
     */
    private $request;

    /**
     * @ORM\Column(name="response_data", type="text", nullable=true)
     * @var string
     */
    private $response;

    /**
     * @return Uuid
     */
    public function getKeyId()
    {
        return $this->keyId;
    }

    /**
     * @return string
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param string $request
     * @return UserActionLogData
     */
    public function setRequest($request)
    {
        $this->request = $request;
        return $this;
    }

    /**
     * @return string
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * @param string $response
     * @return UserActionLogData
     */
    public function setResponse($response)
    {
        $this->response = $response;
        return $this;
    }

    /**
     * @return UserActionLog
     */
    public function getUserActionLog()
    {
        return $this->userActionLog;
    }

    /**
     * @param UserActionLog $userActionLog
     * @return UserActionLogData
     */
    public function setUserActionLog(UserActionLog $userActionLog)
    {
        $this->userActionLog = $userActionLog;
        $this->keyId = $userActionLog->getKeyId();
        return $this;
    }
}
