<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Database\Repository;

use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityRepository;

/**
 * Class Factory
 * @package LifeStyle\SamlAuthBundle\Database\Repository
 */
class Factory
{
    const EM_CONNECTION_NAME = "Backend";

    /**
     * @var array
     */
    private $facSetter;

    /**
     * @var DoctrineRegistry
     */
    private $doctrineRegistry;

    /**
     * Manager constructor.
     * @param DoctrineRegistry $doctrineRegistry
     */
    public function __construct(DoctrineRegistry $doctrineRegistry)
    {
        $this->doctrineRegistry = $doctrineRegistry;
    }

    /**
     * @return EntityRepository
     */
    public function user()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = $this->doctrineRegistry->getRepository(
                'LifeStyleSamlAuthBundle:User',
                static::EM_CONNECTION_NAME
            );
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return EntityRepository
     */
    public function userLoginHistory()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = $this->doctrineRegistry->getRepository(
                'LifeStyleSamlAuthBundle:UserLoginHistory',
                static::EM_CONNECTION_NAME
            );
        }

        return $this->facSetter[__FUNCTION__];
    }
}
