<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Security\Authentication\Matcher;

use Symfony\Component\HttpFoundation\RequestMatcherInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class SamlRequestMatcher
 * @package LifeStyle\SamlAuthBundle\Security\Authentication\Matcher
 */
class SamlRequestMatcher implements RequestMatcherInterface
{
    /**
     * @param Request $request
     * @return bool
     */
    public function matches(Request $request)
    {
        return 1 != getenv('DISABLE_SSO_LOGIN') && ((stripos($request->getRequestUri(), '/admin') === 0) || (stripos($request->getRequestUri(), '/demo') === 0));
    }
}
