<?php

/**
 * @author buchhofer
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Tests\Entity;

use LifeStyle\SamlAuthBundle\Entity\User;
use LifeStyle\SamlAuthBundle\Entity\UserLoginHistory;
use PHPUnit\Framework\TestCase;

/**
 * Class UserTest
 * @package LifeStyle\SamlAuthBundle\Tests\Entity
 */
class UserTest extends TestCase
{

    public function testEntityUser()
    {
        $user = new User();
        $user->setId('4711');
        $user->setUserGuid('userGuid');
        $user->setFirstName('firstName');
        $user->setLastName('lastname');
        $user->setUserName('username');
        $user->setUserEmail('userEmail');
        $user->setCreatedAt();
        $user->setUpdatedAt();

        $userLoginHistory = new UserLoginHistory();
        $userLoginHistory->setLastLoginAt(new \DateTime());
        $userLoginHistory->setLocalUserId('1');
        $userLoginHistory->setUserIdentifier('userIdentifier');
        $userLoginHistory->setUser($user);

        $user->addUserLoginHistory($userLoginHistory);

        $this->assertEquals($user->getId(), '4711');
        $this->assertEquals($user->getUserGuid(), 'userGuid');
        $this->assertEquals($user->getFirstName(), 'firstName');
        $this->assertEquals($user->getLastName(), 'lastname');
        $this->assertEquals($user->getUserName(), 'username');
        $this->assertEquals($user->getUserEmail(), 'userEmail');
        $this->assertInstanceOf(\DateTime::class, $user->getUpdatedAt());
        $this->assertInstanceOf(\DateTime::class, $user->getCreatedAt());

        foreach ($user->getUserLoginHistory() as $loginHistory) {
            $this->assertEquals($loginHistory->getLocalUserId(), '1');
            $this->assertEquals($loginHistory->getUserIdentifier(), 'userIdentifier');
            $this->assertInstanceOf(\DateTime::class, $loginHistory->getLastLoginAt());
            $this->assertNull($loginHistory->getId());
        }
    }
}
