<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle;

use LifeStyle\SamlAuthBundle\Entity\User;
use LifeStyle\SamlAuthBundle\Exceptions\SamlAuthExceptionInterface;
use LifeStyle\SamlAuthBundle\Security\User\SamlUser;

/**
 * Interface UserHandlerInterface
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\SamlAuthBundle
 */
interface UserHandlerInterface
{
    /**
     * @return User|null
     * @throws SamlAuthExceptionInterface
     */
    public function getUser();

    /**
     * @return SamlUser
     * @throws SamlAuthExceptionInterface
     */
    public function getSamlUser();
}
