<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\TemplateBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 * @package LifeStyle\TemplateBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('life_style_template');
        $rootNode
            ->children()
                ->arrayNode('color_assets')
                    ->children()
                        ->scalarNode('base_color_dark')
                        ->isRequired()
                        ->end()
                        ->scalarNode('base_color_light')
                        ->isRequired()
                        ->end()
                     ->end()
                ->end()
            ->end();
        $rootNode
            ->children()
                ->arrayNode('image_assets')
                    ->children()
                        ->scalarNode('logo_path_small')
                        ->isRequired()
                        ->end()
                        ->scalarNode('logo_path_big')
                        ->isRequired()
                        ->end()
                        ->scalarNode('favicon')
                        ->defaultValue('favicon.ico')
                        ->end()
                    ->end()
                ->end()
            ->end();
        $rootNode
            ->children()
                ->arrayNode('text_assets')
                    ->children()
                        ->scalarNode('company_name')
                        ->isRequired()
                        ->end()
                    ->end()
                ->end()
            ->end();
        return $treeBuilder;
    }
}
