<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\TemplateBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class LifeStyleTemplateExtension
 * @package LifeStyle\TemplateBundle\DependencyInjection
 */
class LifeStyleTemplateExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        //set models
        $this->configureColorAssets($config, $container);
        $this->configureImageAssets($config, $container);
        $this->configureTextAssets($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureColorAssets(array $config, ContainerBuilder $container)
    {
        if (!$container->hasDefinition('life_style_template.model.color_assets')) {
            return;
        }

        $definition = $container->getDefinition('life_style_template.model.color_assets');
        $definition->setArguments([
            $config['color_assets']
        ]);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureImageAssets(array $config, ContainerBuilder $container)
    {
        if (!$container->hasDefinition('life_style_template.model.image_assets')) {
            return;
        }

        $definition = $container->getDefinition('life_style_template.model.image_assets');
        $definition->setArguments([
            $config['image_assets']
        ]);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureTextAssets(array $config, ContainerBuilder $container)
    {
        if (!$container->hasDefinition('life_style_template.model.text_assets')) {
            return;
        }

        $definition = $container->getDefinition('life_style_template.model.text_assets');
        $definition->setArguments([
            $config['text_assets']
        ]);
    }
}
